# バッチ設計書 7-Set filter.ps1

## 概要

本ドキュメントは、StaxRipアプリケーションでソースファイルのスキャンタイプに応じてQTGMCフィルタを自動設定するPowerShellスクリプト「Set filter.ps1」の設計書です。

### 本バッチの処理概要

このスクリプトは、StaxRipのAfterSourceLoadedイベントに登録されるイベントハンドラで、ソースファイルのスキャンタイプ（インターレース/プログレッシブ）を検出し、適切なQTGMCフィルタ設定を自動適用します。

**業務上の目的・背景**：動画ファイルにはインターレース（走査線が交互に描画される）とプログレッシブ（フルフレーム描画）の2種類のスキャンタイプがあります。高品質なデインターレース処理を行うにはQTGMCフィルタが使用されますが、入力タイプに応じて適切なInputTypeパラメータを設定する必要があります。このスクリプトは、ソースファイルの読み込み後に自動的にスキャンタイプを判定し、適切なQTGMCフィルタを設定することで、ユーザーの手動設定の手間を省きます。

**バッチの実行タイミング**：StaxRipでソースファイルが読み込まれた後（AfterSourceLoadedイベント発火時）に自動実行されます。スクリプトをStaxRipにロードすると、イベントハンドラとして登録されます。

**主要な処理内容**：
1. AfterSourceLoadedイベントへのイベントハンドラ登録
2. アクティブプロジェクトの最初のソースファイルからスキャンタイプを取得
3. スキャンタイプに応じたQTGMCフィルタ設定の適用
   - Interlaced: InputType=0（インターレース用）
   - Progressive: InputType=1（プログレッシブ用）

**前後の処理との関連**：ソースファイルの読み込み処理の後、フィルタスクリプトの設定に影響します。設定されたフィルタは後続のエンコード処理で使用されます。

**影響範囲**：プロジェクトのスクリプト設定（Fieldカテゴリのフィルタ）に影響します。既存のFieldフィルタ設定は上書きされます。

## バッチ種別

イベントハンドラ / 自動設定

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ソースファイル読み込みごと |
| 実行時刻 | ソースファイル読み込み後 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | AfterSourceLoadedイベント |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| StaxRipの実行 | StaxRipアプリケーションが起動していること |
| スクリプトの登録 | スクリプトがStaxRipにロードされイベントハンドラが登録されていること |
| QTGMCフィルタ | QTGMCフィルタがAviSynth/VapourSynth環境にインストールされていること |

### 実行可否判定

スキャンタイプが「Interlaced」または「Progressive」の場合に設定が適用されます。それ以外の場合（MBAFF、混在等）は設定が行われません。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | イベントから自動取得 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ShortcutModule.p | オブジェクト | アクティブプロジェクト情報 |
| activeProject.FirstOriginalSourceFile | ファイルパス | 最初のソースファイル |
| MediaInfo.GetVideo() | 文字列 | スキャンタイプ情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| activeProject.Script | フィルタスクリプト | QTGMCフィルタ設定 |

### 出力ファイル仕様

ファイル出力はありません。プロジェクトのフィルタスクリプトを変更します。

### フィルタ設定詳細

| スキャンタイプ | フィルタ名 | フィルタコード |
|-------------|----------|-------------|
| Interlaced | QTGMC Interlaced | QTGMC(Preset = "Medium", InputType=0) |
| Progressive | QTGMC Progressive | QTGMC(Preset = "Medium", InputType=1) |

## 処理フロー

### 処理シーケンス

```
1. イベントハンドラ登録
   └─ Register-ObjectEventでAfterSourceLoadedイベントに登録
2. イベント発火時の処理
   └─ アクティブプロジェクト取得
3. スキャンタイプ取得
   └─ MediaInfo.GetVideoで'ScanType'を取得
4. スキャンタイプ判定
   └─ Interlaced または Progressive を判定
5. フィルタ設定
   └─ SetFilterメソッドでQTGMCフィルタを設定
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプトロード] --> B[イベントハンドラ登録]
    B --> C[AfterSourceLoadedイベント待機]
    C --> D[イベント発火]
    D --> E[アクティブプロジェクト取得]
    E --> F[スキャンタイプ取得]
    F --> G{スキャンタイプ判定}
    G -->|Interlaced| H[QTGMC InputType=0設定]
    G -->|Progressive| I[QTGMC InputType=1設定]
    G -->|その他| J[設定なし]
    H --> K[処理完了]
    I --> K
    J --> K
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

### テーブル別操作詳細

データベース操作は行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | スクリプトエラー | ソースファイルが存在しない場合 | 処理はスキップされる |
| - | MediaInfoエラー | スキャンタイプが取得できない場合 | 設定は行われない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（イベント駆動） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

$ErrorActionPreference = 'Stop'が設定されているため、エラー発生時はスクリプトが停止します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル |
| 目標処理時間 | 即時（MediaInfo解析に依存） |
| メモリ使用量上限 | 最小限 |

## 排他制御

排他制御は不要です。イベントハンドラはStaxRipのメインスレッドで実行されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | ログ出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- Register-ObjectEventを使用してShortcutModule.gオブジェクトのAfterSourceLoadedイベントに登録します
- MediaInfo.GetVideoメソッドでスキャンタイプを取得します
- SetFilterメソッドの引数：
  - 第1引数: カテゴリ名（'Field'）
  - 第2引数: フィルタ名（識別用）
  - 第3引数: フィルタコード（AviSynthスクリプト）
- QTGMCのPresetは"Medium"に固定されています（パフォーマンスと品質のバランス）
- InputType=0はインターレースソース用、InputType=1はプログレッシブソース用です
- MBAFF（フィールド適応インターレース）などの特殊なスキャンタイプには対応していません
